(define (domain strips_sat_x_1-domain)
 (:requirements :strips :typing :negative-preconditions :equality :durative-actions)
 (:types satellite direction instrument mode)
 (:predicates (on_board ?i - instrument ?s - satellite) (supports ?i - instrument ?m - mode) (pointing ?s - satellite ?d - direction) (power_avail ?s - satellite) (power_on ?i - instrument) (calibrated ?i - instrument) (have_image ?d - direction ?m - mode) (calibration_target ?i - instrument ?d - direction))
 (:durative-action turn_to
  :parameters ( ?s - satellite ?d_new - direction ?d_prev - direction)
  :duration (= ?duration 5)
  :condition (and (at start (pointing ?s ?d_prev))(over all (not (= ?d_new ?d_prev))))
  :effect (and (at end (pointing ?s ?d_new)) (at start (not (pointing ?s ?d_prev)))))
 (:durative-action switch_on
  :parameters ( ?i - instrument ?s - satellite)
  :duration (= ?duration 2)
  :condition (and (over all (on_board ?i ?s))(at start (power_avail ?s)))
  :effect (and (at end (power_on ?i)) (at start (not (calibrated ?i))) (at start (not (power_avail ?s)))))
 (:durative-action switch_off
  :parameters ( ?i - instrument ?s - satellite)
  :duration (= ?duration 1)
  :condition (and (over all (on_board ?i ?s))(at start (power_on ?i)))
  :effect (and (at start (not (power_on ?i))) (at end (power_avail ?s))))
 (:durative-action calibrate
  :parameters ( ?s - satellite ?i - instrument ?d - direction)
  :duration (= ?duration 5)
  :condition (and (over all (on_board ?i ?s))(over all (calibration_target ?i ?d))(over all (power_on ?i))(at start (pointing ?s ?d))(at end (power_on ?i)))
  :effect (and (at end (calibrated ?i))))
 (:durative-action take_image
  :parameters ( ?s - satellite ?d - direction ?i - instrument ?m - mode)
  :duration (= ?duration 7)
  :condition (and (over all (calibrated ?i))(over all (on_board ?i ?s))(over all (supports ?i ?m))(over all (power_on ?i))(over all (pointing ?s ?d))(at end (power_on ?i)))
  :effect (and (at end (have_image ?d ?m))))
)
